import java.io.*;
import java.util.*;
import java.math.*;

public class B implements Runnable {
	private static BufferedReader in;
	private static StringTokenizer st;
	private static PrintWriter out;

	private boolean solveOne() throws IOException {
		int n = nextInt(), m = nextInt(), q = nextInt();
		if (n == 0)
			return false;
		if(n == 1) {
			for(int i = 0; i < m; i++) {
				out.print('0');
			}
			out.print('\n');
			return true;
		}
		
		long[] can = new long[m];
		long[] cannot = new long[m];
		
		StringBuilder beforeSb = new StringBuilder();
		for(int i = 0; i < m; i++) {
			beforeSb.append('0');
		}
		String before = beforeSb.toString();
		
		for (int i = 0; i < q; i++) {
			long mask = Long.parseLong(nextToken(), 2);
			long reverse = ~mask;
			String s = nextToken();
			for(int j = 0; j < m; j++) {
				if(s.charAt(j) != before.charAt(j)) {
					can[j] |= mask;
					cannot[j] |= reverse;
				} else {
					cannot[j] |= mask;
					can[j] |= reverse;
				}
			}
			before = s;
		}
		
		for(int i = 0; i < m; i++) {
			long resultMask = 0;
			for(int j = 0; j < n; j++) {
				if(checkBit(can[i], j) && !checkBit(cannot[i], j)) {
					resultMask |= (1L << j);
				}
			}
			//out.println(resultMask + " " + can[i] + " " + cannot[i]);
			if(Long.bitCount(resultMask) == 1) {
				int resultBit = 0;
				for(int j = 0; j < n; j++) {
					if(checkBit(resultMask, j)) {
						resultBit = j;
						break;
					}
				}
				resultBit = n - resultBit - 1;
				out.print(getChar(resultBit));
			} else {
				out.print('?');
			}
		}
		out.print('\n');
		
		return true;
	}

	private char getChar(int i) {
		if(i < 10) {
			return (char) ('0' + i);
		} else {
			return (char) ('A' + i - 10);
		}
	}

	private boolean checkBit(long mask, long bit) {
		return ((mask >> bit) & 1) != 0;
	}

	private void solve() throws IOException {
		while (solveOne())
			;
	}

	public void run() {
		final String className = this.getClass().getName().toLowerCase();

		try {
			try {
				in = new BufferedReader(new FileReader(className + ".in"));
				out = new PrintWriter(new FileWriter(className + ".out"));
			} catch (FileNotFoundException e) {
				in = new BufferedReader(new InputStreamReader(System.in));
				out = new PrintWriter(System.out);
			}

			solve();

			out.close();
		} catch (IOException e) {
			e.printStackTrace();
			System.exit(1);
		}
	}

	public static void main(String[] args) {
		new B().run();
		// new Thread(null, new Template(), "Template", (1L << 24)).start();
	}

	private String nextToken() throws IOException {
		while (st == null || !st.hasMoreTokens()) {
			String line = in.readLine();
			if (line == null) {
				return null;
			}
			st = new StringTokenizer(line);
		}
		return st.nextToken();
	}

	private int nextInt() throws IOException {
		return Integer.parseInt(nextToken());
	}

	private long nextLong() throws IOException {
		return Long.parseLong(nextToken());
	}

	private double nextDouble() throws IOException {
		return Double.parseDouble(nextToken());
	}

}
